<?php
/** 
 * هذا الملف يُستخدم كقالب HTML للـ PDF
 * يُفترض أن المتغيرات $h (الهيدر) و $rows (التفاصيل) جاهزة
 * تم استدعاؤه من pdf.php أو send_email.php
 */
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<style>
  body {
    font-family: "Tajawal", sans-serif;
    font-size: 14px;
    color: #333;
    direction: rtl;
  }
  .header {
    text-align: center;
    margin-bottom: 10px;
  }
  .header h2 {
    margin: 0;
    font-size: 18px;
  }
  .info {
    margin-bottom: 10px;
    font-size: 12px;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 10px;
  }
  th, td {
    border: 1px solid #666;
    padding: 6px;
    text-align: center;
  }
  tfoot td {
    font-weight: bold;
  }
  .totals td {
    background: #f8f9fa;
  }
  .footer {
    margin-top: 12px;
    text-align: center;
    font-size: 11px;
    color: #666;
  }
</style>
</head>
<body>

<div class="header">
  <h2><?= htmlspecialchars($h['BranchName'] ?? 'المطعم') ?></h2>
  <div>فاتورة تيك أواي #<?= (int)$h['ReceiptID'] ?></div>
  <div><?= date('Y-m-d H:i', strtotime($h['ReceiptDate'])) ?></div>
</div>

<div class="info">
  <div><strong>الكاشير:</strong> <?= htmlspecialchars($h['UserID']) ?></div>
  <?php if (!empty($h['CustomerEmail'])): ?>
    <div><strong>العميل:</strong> <?= htmlspecialchars($h['CustomerEmail']) ?></div>
  <?php endif; ?>
</div>

<table>
  <thead>
    <tr>
      <th>الصنف</th>
      <th>الكمية</th>
      <th>السعر</th>
      <th>القيمة</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= htmlspecialchars($r['ItemName'] ?: $r['ItemID']) ?></td>
        <td><?= (float)$r['Qty'] ?></td>
        <td><?= number_format($r['Price'], 2) ?></td>
        <td><?= number_format($r['Value'], 2) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
  <tfoot>
    <tr class="totals">
      <td colspan="3">الإجمالي قبل الخصم</td>
      <td><?= number_format($h['SubTotal'], 2) ?></td>
    </tr>
    <tr class="totals">
      <td colspan="3">الخصم</td>
      <td><?= number_format($h['Discount'], 2) ?></td>
    </tr>
    <tr class="totals">
      <td colspan="3">الضريبة (<?= (float)$h['TaxRate'] ?>%)</td>
      <td><?= number_format($h['Tax'], 2) ?></td>
    </tr>
    <tr class="totals">
      <td colspan="3">الإجمالي</td>
      <td><?= number_format($h['Total'], 2) ?></td>
    </tr>
    <tr class="totals">
      <td colspan="3">المدفوع</td>
      <td><?= number_format($h['PaidAmount'], 2) ?></td>
    </tr>
    <tr class="totals">
      <td colspan="3">الباقي</td>
      <td><?= number_format($h['ChangeDue'], 2) ?></td>
    </tr>
  </tfoot>
</table>

<div class="footer">
  <?= nl2br(htmlspecialchars($h['PrintFooter'] ?? 'شكراً لزيارتكم 🌹')) ?>
</div>

</body>
</html>
