<?php
require_once __DIR__ . '/../core/auth.php';
require_login();
$pdo = db();

$id = $_GET['id'] ?? null;
$user = null;
$success = $error = "";

// جلب بيانات المستخدم لو تعديل
if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM admins WHERE id=?");
    $stmt->execute([$id]);
    $user = $stmt->fetch();
}

// جلب المجموعات
$groups = $pdo->query("SELECT id, name FROM groups ORDER BY id")
              ->fetchAll(PDO::FETCH_KEY_PAIR);



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username  = trim($_POST['username']);
    $password  = $_POST['password'] ?: null;
    $name      = trim($_POST['name']);
    $phone     = trim($_POST['phone']);
    $email     = trim($_POST['email']);
    $group_id  = $_POST['group_id'] ?: null;
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $avatar    = $user['avatar'] ?? null;

    // رفع صورة جديدة
    if (!empty($_FILES['avatar']['name'])) {
        $uploadDir = __DIR__ . "/uploads/";
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
        $avatar = time() . "_" . basename($_FILES['avatar']['name']);
        move_uploaded_file($_FILES['avatar']['tmp_name'], $uploadDir . $avatar);
    }

    try {
        if ($id) {
            // ✅ تحقق: هل اسم المستخدم مستخدم من شخص تاني؟
            $check = $pdo->prepare("SELECT COUNT(*) FROM admins WHERE username=? AND id<>?");
            $check->execute([$username, $id]);
            if ($check->fetchColumn() > 0) {
                $error = "⚠️ اسم المستخدم '$username' مستخدم بالفعل من قبل.";
            } else {
                // تحديث بيانات المستخدم
                $sql = "UPDATE admins SET username=?, name=?, phone=?, email=?, group_id=?, is_active=?, avatar=?";
                $params = [$username, $name, $phone, $email, $group_id, $is_active, $avatar];
                if ($password) {
                    $sql .= ", password_hash=?";
                    $params[] = password_hash($password, PASSWORD_DEFAULT);
                }
                $sql .= " WHERE id=?";
                $params[] = $id;

                $stmt = $pdo->prepare($sql);
                $stmt->execute($params);
                $success = "✅ تم تعديل بيانات المستخدم بنجاح";
            }
        } else {
            // ✅ تحقق: هل اسم المستخدم موجود أصلاً؟
            $check = $pdo->prepare("SELECT COUNT(*) FROM admins WHERE username=?");
            $check->execute([$username]);
            if ($check->fetchColumn() > 0) {
                $error = "⚠️ اسم المستخدم '$username' موجود من قبل، برجاء اختيار اسم آخر.";
            } else {
                // إضافة مستخدم جديد
                $stmt = $pdo->prepare("INSERT INTO admins 
                    (username,password_hash,name,phone,email,group_id,is_active,avatar)
                    VALUES (?,?,?,?,?,?,?,?)");
                $stmt->execute([
                    $username,
                    password_hash($password, PASSWORD_DEFAULT),
                    $name,$phone,$email,
                    $group_id,$is_active,$avatar
                ]);
                $success = "✅ تم إضافة المستخدم بنجاح";
            }
        }
    } catch (PDOException $e) {
        $error = "❌ خطأ: " . $e->getMessage();
    }
}


?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= $id ? "تعديل" : "إضافة" ?> مستخدم</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div class="container py-4">
  <div class="card">
    <div class="card-header">
      <?= $id ? "✏️ تعديل مستخدم" : "➕ إضافة مستخدم" ?>
    </div>
    <div class="card-body">

      <!-- رسائل التنبيه -->
      <?php if ($success): ?>
        <div class="alert alert-success text-center"><?= $success ?></div>
      <?php elseif ($error): ?>
        <div class="alert alert-danger text-center"><?= $error ?></div>
      <?php endif; ?>

      <!-- نموذج الإدخال -->
      <form method="post" enctype="multipart/form-data" class="row g-3">
        <div class="col-md-6">
          <label class="form-label">اسم الدخول</label>
          <input type="text" name="username" class="form-control" required
                 value="<?= htmlspecialchars($user['username'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">كلمة المرور <?= $id ? "(اتركها فارغة إذا لا تريد التغيير)" : "" ?></label>
          <input type="password" name="password" class="form-control">
        </div>
        <div class="col-md-6">
          <label class="form-label">الاسم</label>
          <input type="text" name="name" class="form-control"
                 value="<?= htmlspecialchars($user['name'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">الهاتف</label>
          <input type="text" name="phone" class="form-control"
                 value="<?= htmlspecialchars($user['phone'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">البريد الإلكتروني</label>
          <input type="email" name="email" class="form-control"
                 value="<?= htmlspecialchars($user['email'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">المجموعة</label>
          <select name="group_id" class="form-select">
            <option value="">— اختر المجموعة —</option>
            <?php foreach ($groups as $gid => $gname): ?>
              <option value="<?= $gid ?>" <?= ($user['group_id'] ?? '') == $gid ? "selected" : "" ?>>
                <?= htmlspecialchars($gname) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">الحالة</label><br>
          <input type="checkbox" name="is_active" <?= !empty($user['is_active']) ? "checked" : "" ?>> مفعل
        </div>
        <div class="col-md-6">
          <label class="form-label">الأفاتار</label>
          <input type="file" name="avatar" class="form-control">
          <?php if (!empty($user['avatar'])): ?>
            <img src="uploads/<?= htmlspecialchars($user['avatar']) ?>" width="60" class="mt-2 rounded-circle">
          <?php endif; ?>
        </div>
        <div class="col-12 text-end">
          <button type="submit" class="btn btn-success px-4">💾 حفظ</button>
          <a href="users.php" class="btn btn-secondary">⬅️ رجوع</a>
        </div>
      </form>

    </div>
  </div>
</div>
</body>

</html>
